classdef meqreprocess_test<meq_test
  % Test meq reprocessing
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
  end
  
  properties(TestParameter)
    
  end
  
  methods(Test,TestTags = {'integration'})
    function fbt_output_should_not_change(testCase)
      [L,~,LY] = fbt('ana',1);
      
      LY1 = meqreprocess(L,LY);
      
      testCase.assertEqual(LY,LY1,'RelTol',1e3*eps,'meqreprocess should not have changed result')
    end
    
    function liuqe_output_should_not_change(testCase)
      [L,~,LY] = liu('ana',2,[],'psichco',1e-8);  
      % need particularly good convergence to avoid differences due to integrals
      % calculated based on data from previous iteration step
      testCase.verifyNotEqual(LY.dz,0,'dz should not be zero for this to be a useful test')
      
      LY1 = meqreprocess(L,LY);
      testCase.assertEqual(LY,LY1,'RelTol',sqrt(eps),'meqreprocess should not have changed result')
            
      % set LY.dz to zero to check effect
      LY.dz = 0;
      LY2 = meqreprocess(L,LY);

      testCase.assertLessThan(norm(LY1.Bm-LY.Bm),norm(LY2.Bm-LY.Bm),'Bm with dz should be better than without')
      testCase.assertLessThan(norm(LY1.Ff-LY.Ff),norm(LY2.Ff-LY.Ff),'Ff with dz should be better than without')     
    end
    
    function mds2meq_reprocessing_should_work(testCase)
      [Lo,LYo] = mds2meq(61400,'LIUQE.M');
      LYo = meqxk(LYo,LYo.t>1 & LYo.t<1.1); % slice some pieces
      LY = meqreprocess(Lo,LYo);
      
      testCase.assertEqual(LY.t,LYo.t,'incorrect t'); % trivial test
    end
    
    function non_matching_basis_function_should_give_warning(testCase)
      [~,~,LY] = fbt('ana',2,[],'bfct',@bfefmex,'bfp',[1,2]); % use bfef basis functions
      
      % try to fit with other bf
      [L] = fbt('ana',2,[],'bfct',@bf3pmex,'bfp',[]); % use bfef basis functions
      
      testCase.assertWarning(@() meqreprocess(L,LY),'MEQREPROCESS:INACCURATE_PROFILE_FIT');
    end
  end
end
