classdef meqps_test < meq_test
  % Tests for meq power supply module  
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbose = 0;
  end
  
  properties(TestParameter)
    Vadelay = {[1e-3,1e-4],[1e-3,0],[0 0]}; % Delay in voltage output
    dt = {1e-5;1e-4}; % time sampling
  end
  
  methods(Test,TestTags={'Unit'})
    
    function test_delay_and_saturation(testCase,dt,Vadelay)
      % Checks whether delays and saturation work as expected
      
      G.na = 2;
      G.Vadelay = Vadelay;
      G.Iamax =  +[100;100];
      G.Iamin =  -G.Iamax;
      G.Vamax =  +[5;10];
      G.Vamin =  -G.Vamax;
      
      N = 1e-3/dt;
      tgrid = (0:N-1)*dt;
      
      Vreq = [1;-1]*round(tgrid/dt);
      V = zeros(size(Vreq));
      I = zeros(size(Vreq));
      
      pstate = []; % forces init in meqps
      for it = 1:N
        [pstate,V(:,it)] = meqps(G,pstate,dt,Vreq(:,it));
      end
      
      if testCase.verbose
        subplot(211)
        plot(tgrid,Vreq,'bx',tgrid,V,'rx--')
      end
      
      itdelay = (G.Vadelay/dt);
      for ia=1:G.na
        Vreqsat = min(max(Vreq,G.Vamin(ia)),G.Vamax(ia));
        testCase.verifyEqual(Vreqsat(ia,1:end-itdelay(ia)),V(ia,itdelay(ia)+1:end))
        
        if testCase.verbose
          subplot(212)
          plot(Vreqsat(ia,1:end-itdelay(ia)),'b'); hold on;
          plot(      V(ia,itdelay(ia)+1:end),'r--');
        end
      end
    end
  end
end
