classdef meqprof_jacobian_test < meq_jacobian_test
  % Test to verify the jacobians of the meqprof functions
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    tok = 'ana';
  end
  
  properties (ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
      meq_jacobian_test.doublets_under_test{:});
  end

  properties (TestParameter)
    convergence_test = struct('true',true,'false',false);
    smalldia = struct('true',true,'false',false);
  end
  
  methods(TestClassSetup)
    function testSetup(testCase, shot)
      testCase.deltaFx = 1e-5;
      testCase.meshDeltaFx = logspace(-6,-5,3);

      t = 0;
      testCase.get_fgs_LLX(shot,t);
    end
  end
  
  methods(Test,TestTags={'Jacobian'})
    function meqprof_finite_difference_test(testCase,convergence_test,smalldia)
      L = testCase.L;
      LX = testCase.LX;

      % Prepare arguments
      F0   = LX.F0;
      F1   = LX.F1;
      rBt  = LX.rBt;
      ag   = LX.ag;

      % Prepare inputs
      fun = @meqprof;
      x0 = {L.fPg,L.fTg,ag,L.pQ.^2,F0,F1,rBt,L.bfct,L.bfp,L.idsx,smalldia};

      % orders of meqpost derivatives output
      names_out = {'PpQ','TTpQ','PQ','TQ','iTQ'};
      nout = numel(names_out);
      iargout = 1:nout;
      names_in = {'ag','F0','F1'};
      nin = numel(names_in);
      % Index of variables in meqintQ inputs
      iargin = [3,5,6];

      J0 = cell(nout, nin);
      [J0{:}] = meqprofJac(x0{:});

      if convergence_test
        % Test convergence
        epsval = repmat({testCase.meshDeltaFx}, 1, nin);
      else
        % Test baseline error
        epsval = repmat({testCase.deltaFx}, 1, nin);
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,{},iargout,names_out,iargin,names_in,epsval);
    end
  end
end
