classdef meqpostq_test < meq_test
  % Comparison tests between meqpostq and psitbx computations
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    data
  end

  properties(ClassSetupParameter)
    % PSITBX only supports single-domain equilibrium
    % Also in limited cases, the boundary point is not treated in the same
    % way.
    shot = struct('diverted',2,'diverted2',3);
  end

  methods(TestClassSetup)
    function setup(testCase,shot)
      % Run FBT
      [L,LX,LY] = fbt('ana',shot,0,...
                      'iterq',20,'noq',128,'pq',linspace(0,1,101),... % Parameters for meqpostq
                      'icsint',true,'ilim',3);                        % Use cubic spline interpolation

      % Store them
      testCase.data = {L,LX,LY};
    end
  end

  methods(Test,TestTags={'Integration'})
    function compare_meqpostq_psipostq(testCase)
      testCase.assumeNotEmpty(which('psitbxp2p'),'skipping psitbx tests since psitbxp2p not in path')
      % Compare meqpostq and psipostq outputs
      [L,~,LY] = deal(testCase.data{:});
      LY2 = psipostq(L,LY);

      % MEQ and PSITBX use different spline boundary conditions for rho and
      % also different interpolated functions, so a small difference is to
      % be expected, which decreases with the size of the rho grid
      tol = 5e-4;
      % The following ignored fields are not directly computed using PSITBX
      ignoredFields = {'aW','FW','lp','rbary','ItQ','LpQ','rbQ','Q5Q','raqmin','qmin','raR','rS','zS'};
      testCase.verifyTrue(structcmp(LY,LY2,tol,ignoredFields),'Comparison with psitbx-based psipostq failed');
    end
  end

end
