classdef meqplottraces_tests < meq_test
  % tests for meqplottraces
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    myobj % meqplottraces object
    verbosity = 0;
    data
    hf
  end

  properties (ClassSetupParameter)
    calltype = {'simple','multiple LY'}
  end

  properties (TestParameter)
    doscale = {true,false}
    settings_case = {'scale','ylim','single-traces',...
      'single-and-multi-traces','function_handles'}
  end

  methods(TestClassSetup)
    function setup_figure(testCase,calltype)
      % generate sequence of test equilibria
      [L,LX,LY] = fbt('ana',101,[]);

      testCase.data.L  = L;
      testCase.data.LY = LY;
      
      if testCase.verbosity, vis = 'on'; else, vis = 'off'; end
      hf_ = figure('name','MEQ time trace plotter',...
        'Visible',vis);
      testCase.addTeardown(@close,hf_)
      testCase.hf = hf_;

      switch calltype
        case 'simple'
          % do nothing
        case 'multiple LY'
          % run another case
          LX.Wk = LX.Wk*2;
          LY2 = fbtt(L,LX);
          testCase.data.LY2 = LY2;
        otherwise, error('unsupported calltype %s',calltype)
      end

    end
  end

  methods (Test,TestTags={'Integration'})
    function test_basic_operation(testCase,settings_case)
      % get data
      L  = testCase.data.L;
      LY = testCase.data.LY;
      if isfield(testCase.data,'LY2')
        LY2 = testCase.data.LY2;
        LY = {LY,LY2}; % multiple time traces
      end

      % settings per case
      switch settings_case
        case 'scale'
          PP = {'traceinfo',{'Ip'},'scaleinfo',{1e-3}};
        case 'ylim'
          PP = {'traceinfo',{'Ip'},'yliminfo',{[0,1e6]}};
        case 'single-traces'
          PP = {'traceinfo',{'Ip','Wk','bp','Vp'}};
        case 'single-and-multi-traces'
          % custom labels and traces
          PP = {'traceinfo',{'Ip','Ia'},...
          'ylabelinfo',{'Ip','dima'},'titleinfo',{'Ip',L.G.dima}};
        case 'function_handles' 
          % function handle to specity traces
          % default + direct specification for ylabelinfo
          PP = {'traceinfo',{@(LY) sum(LY.Iv,1), @(LY) LY.Ia },...
            'ylabelinfo',{{},L.G.dima},...
            'titleinfo',{'\Sigma Iv','Ia'}};
      end

      % test plotting
      clf(testCase.hf);
      testCase.myobj = meqplottraces(L,LY,...
        'parent',testCase.hf,PP{:});
      drawnow

      % test that we can set the selected time index
      testCase.myobj.time_index = 3;
      testCase.assertEqual(testCase.myobj.time_index,3,'could not set time index');
      
    end
  end
end
