classdef meqpdom_failure_test < meq_test
  % Tests for meqpdom failure modes
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties(TestParameter)
    idref = {'NoMagAx','NoLCFS','MagAxHess','TooManyDomains'}
  end

  methods(Test,TestTags={'Unit'})
    function meqpdom_fail_test(testCase,idref)
      % Test meqpdom identifies errors correctly
      L = fbt('ana',1,[],'nz',16,'nr',33);

      Fx = 1e-6*((L.rrx - L.G.rx(17)).^2 + (L.zzx).^2); % Small baseline Fx
      sIp = -1; % Direction of current

      switch idref
        case 'NoMagAx'
          Fx = 1e-3*(L.rrx - L.G.rx(17)); % Monotonic flux, no singular points
        case 'NoLCFS'
          sIp = +1; % Wrong sign of Ip leads to no valid limiter candidate
        case 'MagAxHess'
          % Failing case (see MEQ GitLab issue #675)
          Fx_ = ...
            [-0.00936344177921167   -0.0071612328815140432 -0.00833010523634605   -0.01326389497371675;
             -0.0057777873326649923 -0.0055422538457498456 -0.0057088671466086205 -0.010124732075160875;
             -0.0093634417792119173 -0.0071612328815138923 -0.0083301052363459437 -0.013263894973717246];

          Fx(15:17,16:19) = Fx(15:17,16:19) + Fx_ - mean(Fx_(:)); % Add perturbation near axis
        case 'TooManyDomains'
          L.nD=0; % Cheating ...
      end

      args = cell(23,1); %  meqpdom outputs
      [args{:}] = meqpdom(Fx,sIp,1,L);
      stat = args{21};
      id = args{23};

      testCase.verifyFalse(stat,'meqpdom status is true when expecting false')
      testCase.verifyEqual(id,idref,sprintf('Expected %s failure but got %s instead',idref,id));
    end
  end

end