classdef meqintQ_jacobian_test < meq_jacobian_test
  % Test to verify the jacobians of the meqintQ function
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    tok = 'ana';
  end
  
  properties (ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
      meq_jacobian_test.doublets_under_test{:});
  end

  properties (TestParameter)
    convergence_test = struct('false',false,'true',true);
  end    
  
  methods(TestClassSetup)
    function testSetup(testCase, shot)
      testCase.deltaFx = 1e-7; % Need a low value to avoid points jumping from one radial cell to the next
      testCase.meshDeltaFx = logspace(-7.5,-6.5,3);

      t = 0;
      testCase.get_fgs_LLX(shot,t);
    end
  end
  
  methods(Test,TestTags={'Jacobian'})
    function meqintQ_finite_difference_test(testCase,convergence_test)
      L = testCase.L;
      LX = testCase.LX;

      % Prepare arguments
      F0   = LX.F0;
      F1   = LX.F1;
      rBt  = LX.rBt;
      ag   = LX.ag;
      Fx   = LX.Fx;
      Opy  = LX.Opy;

      % Prepare inputs
      fun = @meqintQ;
      x0 = {L,F0,F1,rBt,ag,Fx,Opy};

      % order of meqintQ derivatives output
      funs = {'IpQ','WkQ','WpQ','FtQ'};
      nfuns = numel(funs);
      % Index in meqintQ outputs (others have zero jacobians)
      iargout = [1,2,3,5];
      vars = {'ag','Fx','F0','F1'};
      nvars = numel(vars);
      % Index of variables in meqintQ inputs
      iargin = [5,6,2,3];

      J0 = cell(nfuns, nvars);
      [J0{:}] = meqintQJac(x0{:});

      if convergence_test
        % Test convergence
        epsval = repmat({testCase.meshDeltaFx}, 1, nvars);
      else
        % Test baseline error
        epsval = repmat({testCase.deltaFx}, 1, nvars);
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,{},iargout,funs,iargin,vars,epsval);
    end
  end
end
