classdef meqgui_test < meq_test
  % tests for MEQ GUIs
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    myobj % meqplotslider object
    verbosity = 0;
    hf % figure handle
    data % eq data container
  end


  methods(TestClassSetup)
    function setup(testCase)
      % generate sequence of test equilibria
      [L,LX,LY] = fbt('ana',101,[]);
      testCase.data.L = L;
      testCase.data.LX = LX;
      testCase.data.LY = LY;

      if testCase.verbosity, vis = 'on'; else, vis = 'off'; end
      hf_ = figure('name','MEQ equilibrium inspector',...
        'Visible',vis);
      testCase.addTeardown(@close,hf_)
      testCase.hf = hf_;
    end
  end

  methods(Test,TestTags = {'Integration'})
    function test_gui_use(testCase)
      % get data
      L  = testCase.data.L;
      LY = testCase.data.LY;

      % create gui
      obj = meqgui(L,LY,'parent',testCase.hf);

      % change time indices to trigger listeners
      obj.timetraces.time_index = 3;  % set time trace timeslice
      obj.eqslider.set_time_slice(5); % set eq slider timeslice
    end
  end
end
