classdef meqgtcv_test < meq_test
  % test for meqgtcv
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  methods(TestClassSetup)
    function connect_to_tcvdata(testCase)
      server = meqmdsserver();
      status = mdsconnect(server);
      testCase.assertTrue(isodd(status),'mdsconnect to tcvdata.epfl.ch failed');
    end
  end

  properties(TestParameter)
    static={1,2,3,4,5,6,7}
  end
  
  methods(Test, TestTags = {'TCV'})
    function test_tcv_static(testCase,static)
      % Checks ability to change TCV static tree version
      
      standard_shot = 9e5;
      L = fbt('tcv',standard_shot,[],'static',static);

      mdsopen('static',static);
      % meq limiter is a subsampled version of the "t" static system
      diml = cellstr(num2str((1:512/L.G.nl:512)','%03d'  ));
      rl = mdsvalue('static("r_t")[$1]',diml);
      zl = mdsvalue('static("z_t")[$1]',diml);

      testCase.verifyEqual(L.G.rl,rl,sprintf('Mismatch between L.G.rl and data from static tree for static=%d',static));
      testCase.verifyEqual(L.G.zl,zl,sprintf('Mismatch between L.G.zl and data from static tree for static=%d',static));
    end
  end
  
end
