classdef meq_solver_test < meq_test
  % Superclass for tests of functions in solver directory
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    A_
    b_
    m_
    Pinv_
    tol_ = 1e-12;
    precside_ = 'right';
  end

  properties(ClassSetupParameter)
    variant = {'simple','zero','handle','prec','prec_handle'}
  end

  properties(Abstract,ClassSetupParameter)
    nb
  end

  methods (TestClassSetup)
    function setup(testCase,variant,nb)
      % Generate a linear function and RHS to test linear solvers

      n = 300;
      A = rand(n,n );
      b = rand(n,nb);
      m = n/nb;
      Pinv = [];

      % Variant
      switch variant
        case 'simple'
        case 'zero'
          b = zeros(n,nb);
        case 'handle'
          A = @(x) A*x;
        case 'prec'
          Pinv = 1;
        case 'prec_handle'
          Pinv = @(x) x;
      end

      testCase.A_    = A;
      testCase.b_    = b;
      testCase.m_    = m;
      testCase.Pinv_ = Pinv;
    end
  end

  methods
    function check_result(testCase,x)
      % Verify x is solution of A*x=b

      A    = testCase.A_;
      b    = testCase.b_;
      tol  = testCase.tol_;

      if isa(A,'function_handle')
        res = zeros(size(b));
        for ii = 1:size(res,2)
          res(:,ii) = A(x(:,ii))-b(:,ii);
        end
      else
        res = A*x-b;
      end
      testCase.verifyEqual(res,zeros(size(b)),'AbsTol',10*tol);
    end
  end
end
