classdef meq_check_headers < check_headers & meq_test
  % Checks whether desired copyright headers are in place
  % Can be used to fix them automatically by setting `dofix=true`
  % mytest = check_headers
  % mytest.dofix = true; % changes property
  % mytest.run; % runs
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.
  
  properties
    dofix = false; % if true, modify files to fix header
    IgnoredPaths = {'csfc','obj','slprj','.git','tutorials','genlib'};
    IgnoredFilenames = {'rtwmakecfg.m'};
    old_headers = {'[+MEQ MatlabEQuilibrium Toolbox+]',...
      'FreeBoundaryTokamakEquilibrium',...
      'LIUQEibrium reconstruction',...
      '[+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.'};
    desired_header = 'Copyright 2022-2025 Swiss Plasma Center EPFL';
    test_folder = fileparts(fileparts(mfilename('fullpath')));
  end

  methods(Test,TestTags={'Unit'})
    function check_and_fix_files(testCase)
      check_and_fix_files@check_headers(testCase);
    end
  end
end
