classdef lyall_tests < meq_test
% Tests of returining all LY time slices also for failed slices.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

  properties
    verbose = 0;
  end

  properties (TestParameter)
    LYall = struct('true',true,'false',false);
    iterq = struct('on',1,'off',0);
  end
  
  methods(Test,TestTags={'Unit'})
    function test_lyall(testCase,LYall,iterq)
      % Tests to check output of failing slices with and without FS
      % post-processing

      % Set very high Ipmin to force early failure
      [~,~,LY] = liu('ana',1,[],'LYall',LYall,'iterq',iterq,'Ipmin',Inf);
      
      if LYall
        testCase.verifyTrue(~isempty(LY),'LY is empty with LYall=true');
        testCase.verifyTrue(~LY.isconverged,'liu has converged on a case with abs(Ip)<Ipmin');
      else
        testCase.verifyTrue(isempty(LY),'LY is not empty with LYall=false');
      end
    end
  end

  methods(Test,TestTags={'TCV'})
    function test_lyall_meqpostq_vacuum(testCase)
      % Tests compatibility of meqpostq with LYall and no plasma
      [ok,msg] = meq_test.check_tok('tcv');
      testCase.assumeTrue(ok,msg);

      % This should be replaced by a vacuum shot with tok=ana

      % Set negative time to enforce vacuum solution
      [~,~,LY] = liu('tcv',55555,-0.3,'LYall',true,'iterq',1,'Ipmin',Inf);

      testCase.verifyTrue(~isempty(LY),'LY is empty with LYall=true');
    end
  end
end
