classdef liutcv_doublet_test < meq_test
  % Test liu for different doublet application
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties (TestParameter)
    shot_t = liutcv_doublet_test.get_shot_t();
  end
  
  methods (Static)
    % Only to get helpful names for parameter values
    function x = get_shot_t()
      
      shots = { 55331, 68443, 68466, 68509, 68596, 68898, 69103, 69403, 69403};
      times = {0.0100,2.4220,2.4230,2.4090,2.4090,2.4130,1.4110,0.4100,1.4100};
      
      x = struct();
      for ii = 1:numel(shots)
        x.(strrep(sprintf('TCV%05d_%6.4f',shots{ii},times{ii}(1)),'.','s')) = [shots(ii),times(ii)];
      end
      
    end
  end
  
  properties
    debug    = 0;
  end
  
  methods(Test,TestTags={'TCV'},ParameterCombination='sequential')
    
    function liutcv_doublet(testCase, shot_t)
      %% Check equilibrium reconstruction droplet/doublet from TCV data
      shot = shot_t{1};
      t    = shot_t{2};
      
      % Get default parameter for multiple domains and overload specific requests
      inPar = {'idoublet', true, 'debug', testCase.debug, 'useSQP',false,'stabz',1,'wdz',[0;0;Inf]};
      inPar = liup_doublet( inPar{:} );
      [L,LX,LY] = liuqe( shot, t,inPar{:});
      
      testCase.verifyTrue(meq_test.check_convergence(L,LX.t,LY),sprintf('LIUQE did not converge for doublet/droplet case %05d/%6.4s',shot,t(1)));
      testCase.verifyEqual(LY.Ip,LX.Ip,'Abstol',L.P.Iperr,sprintf('Reconstructed Ip does not match within tolerance for doublet/droplet case %05d/%6.4s',shot,t(1)));
      
    end
    
  end
end