classdef liuptcv_test < meq_test
  % tests for LIUQE parameter retrieval for TCV
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  methods(TestClassSetup)
    function connect_to_tcvdata(testCase)
      server = meqmdsserver();
      status = mdsconnect(server);
      testCase.assertTrue(isodd(status),'mdsconnect to tcvdata.epfl.ch failed');
    end
  end
  
  methods(Test, TestTags = {'TCV'})
    function test_liuptcv_default(testCase)
      % Compares parameter values for LIUQE in the results model tree and
      % those in liuptcv_default
      
      Pmodel   = liuptcv(-1,'psrc','LIUQE.M');
      Pdefault = liuptcv([],'psrc','default');
      
      testCase.verifyTrue(structcmp(rmfield(Pmodel  ,{'psrc','wBm','shot'}),...
                                    rmfield(Pdefault,{'psrc','wBm'       }),...
                                    eps('single')),...
                          'LIUQE parameters stored in the model tree do not match the defaults from liuptcv');
    end
  end
  
end
