classdef liuanasrv_test < meq_test
  % tests for automated LIU runs for TCV including storage to MDSplus
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties (TestParameter)
    shot = {55555};
    analysis = {'thomson','fast'};
  end

  methods(Test, TestTags = {'TCV'})
    function test_liuanasrv(testCase,shot,analysis)
      % Runs liuanasrv

      % Check that TCV tools are available
      testCase.check_tok('tcv');

      % Setup temporary MDSplus storage
      testCase.applyFixture(tcv_temp_tree_fixture('results',shot));

      % Disable DML fitting for this run if the dml toolbox is not available
      if isempty(which('dmlbo'))
        mdsopen('results',shot);
        mdsput('\results::equil_param:idml',int32(0));
      end
      % Run liuanasrv
      liuanasrv(shot,[],analysis);
    end
  end
  
end
