classdef lih_tests < meq_test
  % Tests for LIH
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    tok = 'ana';
    t = 0;
    verbosity = 0;
    itert = 1;
    L,LX; 
    Lfbt,LYfbt;
  end

  properties(ClassSetupParameter)
    config = {'vacuum-forced','vacuum','limited','diverted','doublet'};
    iterh = {0,10};
  end
  
  methods(TestClassSetup)
    function setup_LLX(testCase,config,iterh)
      Ipvacuum = 0; % default
      switch config
        case 'vacuum-forced'
          shot = 91; Ipvacuum = 1; % force treatment as vacuum for Ip < 1A
        case 'vacuum'
          shot = 91;
        case 'limited'
          shot = 1;
        case 'diverted'
          shot = 2;
        case 'droplet'
          shot = 81;
        case 'doublet'
          shot = 82;
        otherwise
          error('undefined config %s\n',config)
      end
      tok = testCase.tok; t=testCase.t; %#ok<*PROPLC>
      
      [Lfbt,~,LYfbt] = fbt(tok,shot,t);
      [L] = lih(tok,shot,t,'iterh',iterh,...
        'debug',testCase.verbosity,'itert',testCase.itert,...
        'nelem',12,'Ipvacuum',Ipvacuum,'Ipmin',Ipvacuum);
      LX = meqxconvert(Lfbt,LYfbt,L);
      testCase.LX = LX;
      testCase.L = L;
      testCase.LYfbt = LYfbt;
      testCase.Lfbt = Lfbt;
    end
  end
  
  methods(Test,TestTags={'Unit'})
    function test_lih(testCase)
      L   = testCase.L; LX=testCase.LX; %#ok<*PROP>
      LYh = liht(L,LX);
      Lf  = testCase.Lfbt; LYf = testCase.LYfbt;
   
      if testCase.verbosity
        clf
        subplot(121);         
        imagesc(Lf.ry,Lf.zy,LYf.Iy); axis xy; title('FBT'); hold on;
        plot(LYf.rA,LYf.zA,'+k');
        plot(LYh.rA,LYh.zA,'or');

        subplot(122); 
        imagesc(L.ry,L.zy,LYh.Iy); axis xy; title('LIH'); hold on;
        plot(LYh.rA,LYh.zA,'or');
        drawnow
      end
      
      testCase.verifyTrue(~isempty(LYh),'liht returned empty');
      testCase.verifyEqual(LYh.Ip,LX.Ip,'AbsTol',2*L.P.Iperr,'Ip does not match')
      testCase.verifyEqual(LYh.Ia,LX.Ia,'AbsTol',2*L.P.Iaerr,'Ia does not match')
      testCase.verifyEqual(LYh.Iu,LX.Iu,'AbsTol',2*L.P.Iuerr,'Iu does not match')
      
      if LYf.Ip~=0 % don't check centroid position for vacuum cases
        testCase.verifyEqual(LYh.zY,LYf.zY,'AbsTol',0.1)
        testCase.verifyEqual(LYh.rY,LYf.rY,'AbsTol',0.1 )
      elseif abs(LYf.Ip) < L.P.Ipvacuum
        % special case with Jh and Iy constrained to 0
        testCase.verifyEqual(LYh.Ip,0,'Ip not exactly zero?')
      end
    end
  end
end
