classdef ilackner_test < meq_test
  % Test to ensure that the ilackner option leads to similar results
  % in the inversion of the GS operator meqFx
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    LX;
    Fx;
    machine;
    shot;
    verbosity = 0;
  end
  
  properties(TestParameter)
    lackner_option = {'0', '2'};
  end
  
  properties (ClassSetupParameter)
    machines = {'ana'};
    shots = {'1', '2', '3', '5', '82'};
  end
  
  methods(TestClassSetup)
    function testSetup(testCase, machines, shots)
      [L, testCase.LX] = fgs(machines, str2double(shots), 0, 'ilackner', 1);
      Ie = [testCase.LX.Ia; testCase.LX.Iu];
      testCase.Fx = meqFx(L, testCase.LX.Iy, Ie);
      testCase.machine = machines;
      testCase.shot = shots;
    end
  end
  
  methods(Test,TestTags={'Unit'})
    
    function test_meqFx_with_lackner_options(testCase, lackner_option)
      Iy = testCase.LX.Iy;
      Ie = [testCase.LX.Ia; testCase.LX.Iu];
      Fx_baseline = testCase.Fx;
      
      L = fgs(testCase.machine, str2double(testCase.shot), 0, 'ilackner', str2double(lackner_option));
      
      Fx_test = meqFx(L, Iy, Ie);
      testCase.verifyEqual(Fx_baseline, Fx_test, 'AbsTol', 5e-3);
    end
    
  end
end
