classdef gmres_block_test < meq_solver_test
  % Test the Block-GMRES algorithm
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties(ClassSetupParameter)
    nb = {20}
  end

  properties (TestParameter)
    algoGMRES = {'sim','giv','qr'}
  end

  methods (Test, TestTags = {'Unit'})
    function test_gmres_block(testCase,algoGMRES)
      % Test Block-GMRES algorithm
      
      A    = testCase.A_;
      b    = testCase.b_;
      m    = testCase.m_;
      tol  = testCase.tol_;
      Pinv = testCase.Pinv_;

      x = gmres_block(A,b,algoGMRES,tol,m,Pinv);

      % Check result
      testCase.check_result(x);
    end
  end
end