classdef (SharedTestFixtures={mexm_fixture}) fsg2_test < meq_test
  % Tests for flux surface geometric integrals 2 calculations
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    L; LY;
    rel_tol = 1e-2; % Error is dominated by pq resolution at the edge.
    verbosity = 1;
  end
  
  properties (MethodSetupParameter)
    npq = {32  64};
  end
  
  properties (TestParameter)
    method = {'fsg2mex','fsg2mexm'};
  end
    
  methods(TestMethodSetup)
    function fsgiTestSetup(testCase,npq)
      L = fbt('ana',1,1,'iterq',1,'pq',linspace(0,1,npq).^0.5);

      % calculate axis location and radius of circle a0
      r0 = (L.rx(end)+L.rx(1))*0.5; 
      z0 = 0;
      FA = 1;
      FB = 1.3;
      rBt = 1.4;
      
      [testCase.L,testCase.LY] = testCase.getCircularEquilibrium(L,r0,z0,FA,FB,rBt);
    end
  end

  methods(Test, TestTags = {'Unit'})
    function test_fsgi(testCase,method)
      
      %%
      L = testCase.L; %#ok<*PROPLC> % for brevity
      LY = testCase.LY;
  
      % contour integrals
      [VQ,AQ] = feval(method,LY.aq,LY.rA,L.crq,L.doq);
      
      tol = testCase.rel_tol;
      testCase.verifyEqual(VQ,LY.VQ,'RelTol',tol,'VQ value from fsg2mex does not match analytical value within tolerance');
      testCase.verifyEqual(AQ,LY.AQ,'RelTol',tol,'AQ value from fsg2mex does not match analytical value within tolerance');
      
      if testCase.verbosity
        %%
        clf;
        subplot(2,1,1);hold all;
        plot(L.pQ,   VQ);
        plot(L.pQ,LY.VQ,'--','Linewidth',2);
        title('VQ')
        
        subplot(2,1,2);hold all;
        plot(L.pQ,   AQ);
        plot(L.pQ,LY.AQ,'--','Linewidth',2);
        title('AQ')
      end
      
    end
    
  end
  
  
end
