classdef flcs_jacobian_test < meq_jacobian_test
  % Test the jacobian of flcs function
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    tok = 'ana';
  end
    
  properties(ClassSetupParameter)
    shot = struct('circular',1,'diverted',2,'diverted2',3,'squashed',5,...
        meq_jacobian_test.doublets_under_test{:});
  end

  properties (TestParameter)
    convergence_test = struct('false',false,'true',true);
  end
  
  methods(TestClassSetup, ParameterCombination='sequential')
    function setup(testCase,shot)
      testCase.deltaFx = 5e-7; % Lower perturbation

      % Compute FGS initial guess (FBT solution)
      t = 0;
      testCase.get_fgs_LLX(shot,t);
      testCase.L.P.icsint = true;
      testCase.L.P.ilim = 3;
      testCase.L = fgsc(testCase.L.P,testCase.L.G);
    end
  end
      
  methods(Test,TestTags={'Jacobian'})
    function test_extremum_jacobian(testCase,convergence_test)

      L = testCase.L;
      LX = testCase.LX;
      Fx = LX.Fx;
      FN = sign(LX.Ip)*L.FN;

      % Prepare arguments
      fun = @flcs;
      x0 = {Fx,FN,L};

      % Get positions
      [Fl,rl,zl] = flcs(x0{:});

      % Check Fl only
      names_out = {'Fl'};
      iargout = 1;
      names_in = {'Fx'};
      iargin = 1;

      % Get jacobians
      J0 = cell(1,1);
      [J0{:}] = flcsJac(rl,zl,L);

      % Discard non-extremum points (where Fl is FN)
      J0{1}(Fl == FN,:) = 0;

      % F0 sizes
      jacfd_args = {'szF0',{L.G.nl}};

      if convergence_test
        % Test convergence
        epsval = {testCase.meshDeltaFx};
      else
        % Test baseline error
        epsval = {testCase.deltaFx};
      end
      % Call generic function
      testCase.test_analytical_jacobian(...
        fun,x0,J0,jacfd_args,iargout,names_out,iargin,names_in,epsval);
    end
  end
end
