classdef fgstcv_test < meq_test
  % Tests of Static Forward-Grad-Shafranov solver FGS
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    tok = 'tcv'
    dosave = false;
    verbosity = 0;
    LXliu
    LXfbt
  end
  
  properties(TestParameter)
    src = {'liu','fbt'}; % data sources for fgs
    method = {'all-nl','Picard'};
  end
  
  properties(ClassSetupParameter)
    shot = struct('diverted',61400,'limited',65000,'snowflake',       65270);
    t    = struct('diverted',  0.4,'limited',    1,'snowflake',0.4:0.05:0.7);
  end
  
  methods(TestClassSetup, ParameterCombination='sequential')
    function get_LLX(testCase,shot,t)
      % get L, LX structures from tree, or from file
      tok_ = testCase.tok; %#ok<*PROPLC>
      
      [ok,msg] = testCase.check_tok(tok_,shot);
      testCase.assumeTrue(ok,msg);

      fprintf('Setting up test for tok:%s shot:%d t1=%f\n',tok_,shot,t(1));

      bfct = @bf3pmex; bfp = false;
      args = {'bfct',bfct,'bfp',bfp};
      
      [~,testCase.LXliu] = fgs(tok_,shot,t,'insrc','liu',args{:});
      [~,testCase.LXfbt] = fgs(tok_,shot,t,'insrc','fbt',args{:});

    end
  end
  
  methods(Test,TestTags={'fgs'})
    
    function test_fgs(testCase,src,method)

      switch src
        case 'liu', LX = testCase.LXliu;
        case 'fbt', LX = testCase.LXfbt;
        otherwise, error('Catastrophic error');
      end

      tok = testCase.tok;
      bfct = @bf3pmex; bfp = false;
      insrc = src;
      algoNL = method;
      if ~isequal(method,'Picard')
        usepreconditioner = true;
        anajac = true;
        icsint = false;
        ilim = 1;
      else
        usepreconditioner = false;
        anajac = false;
        icsint = true;
        ilim = 3;
      end
      
      L = fgs(tok,LX.shot(1),LX.t(1),'debug',testCase.verbosity,...
        'insrc',insrc,'bfct',bfct,'bfp',bfp,'algoNL',algoNL,...
        'usepreconditioner',usepreconditioner,'anajac',anajac,...
        'icsint',icsint,'ilim',ilim);
      LX = fgsx(L,LX);

      LY = fgst(L,LX);
      testCase.verifyTrue(meq_test.check_convergence(L,LX.t,LY),'did not converge');
    end
    
  end
end
