classdef (SharedTestFixtures={meq_fixture}) ...
    fgslin_full_test < matlab.unittest.TestCase
  % Tests of fgslin_full
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties (TestParameter)
    shot_tcv = {61400}
    t_tcv = {1};
    shot_ana = {2}
    t_ana = {0};
  end
  
  properties
    verbosity = 1;
    tol = 1e-2;
  end
  
  methods (Test, TestTags = {'TCV'})
    function test_fgs_linearization_tcv(testCase,shot_tcv,t_tcv)
      test_fgs_linearization(testCase,'tcv',shot_tcv,t_tcv);
    end
  end

  methods (Test, TestTags = {'fgs'})
    function test_fgs_linearization_ana(testCase,shot_ana,t_ana)
      test_fgs_linearization(testCase,'ana',shot_ana,t_ana);
    end
  end

  methods
    function test_fgs_linearization(testCase,tok,shot,t)
      % checks linearization using fgslin_full (finite differences in all
      % directions and full recomputation of converged FGS equilibrium

      [L,LX,LY] = fgs(tok,shot,t,'tolF',1e-9,...
        'mkryl',50,'usepreconditioner',0,...
        'selu','e','nu',30,...
        'debug',testCase.verbosity);
      [dLY_dIa,dLY_dIu,dLY_dCo] = fgslin_full(L,LY);
      
      %% check w.r.t. Ia/Iu/Co perturbation
      nx = L.G.na + L.G.nu + L.nC;
      Co = LX2Co(L,LX);
      dIa = 1e-4*randn(size(LX.Ia)).*LX.Ia;
      dIu = 1e-4*randn(size(LX.Iu));
      dCo = 1e-4*randn(size(Co   ));
      LX.Ia = LX.Ia + dIa;
      LX.Iu = LX.Iu + dIu;
      LX = Co2LX(L,LX,Co+dCo);
      LY1 = fgst(L,LX);
      
      checkfields = {'rA','zA','Fx','FA','FB','PQ','TQ','rB','zB','bp','Ip','qA'};
      for ifield=checkfields
        myfield = ifield{:};
        if isscalar(LY1.(myfield)) || iscolumn(LY1.(myfield))
          ndims_dLY = 2;
        else
          ndims_dLY = ndims(LY1.(myfield))+1;
        end
        % Estimate change in field value from linearization
        linval = sum(cat(ndims_dLY,dLY_dIa.(myfield),dLY_dIu.(myfield),dLY_dCo.(myfield)).*reshape([dIa;dIu;dCo],[ones(1,ndims_dLY-1),nx]),ndims_dLY);
        % Effective change in field value
        numval = LY1.(myfield)-LY.(myfield);
        % Tolerance
        tol_ = max(max(abs(LY.(myfield)))); % Field might be up to 2D
        % Check
        testCase.verifyEqual(numval,linval,'AbsTol',tol_,sprintf('residual too high for %s',myfield));
      end
    end
  end
end
