classdef fge_vacuum_tests < meq_test
  % Tests of vacuum running case of fge
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    verbosity = 0;
    tol = 1e-12;
  end
  
  methods (Test,TestTags={'fgelin'})
    
    function test_vs_ODE(testCase)
      % Tests for FGE vacuum solver
      Ts = 1e-3;
      t = (-0.3:Ts:-0.2);
      [L,LX,LY] = fge('ana',91,t,...
        'selu','e','nu',30,'debug',testCase.verbosity); % Test debug output in vacuum
      
      %% Solve using direct ODE
      A = (L.Mee + Ts*diag(L.Re))\(L.Mee);
      B = (L.Mee + Ts*diag(L.Re))\(Ts*eye(L.ne,L.G.na));
      
      nt = numel(LX.t);
      ia = 1:L.G.na; iu = L.G.na+(1:L.G.nu);
      X = [LX.Ia(:,1);LX.Iu(:,1)]; u = LX.Va;
      
      for kt = 2:nt
        X(:,kt) = A*X(:,kt-1) + B*u(:,kt);
      end
      
      if testCase.verbosity
        subplot(211)
        plot(t,X(ia,:),'b',t,LY.Ia,'r--')
        subplot(212)
        plot(t,X(ia,:)-LY.Ia)
      end
      
      testCase.verifyEqual(X(ia,:),LY.Ia,'AbsTol',testCase.tol*L.Ia0);
      testCase.verifyEqual(X(iu,:),LY.Iu,'AbsTol',testCase.tol*L.Iu0);
    end
  end
end
