classdef fbtana_test < meq_test
% Various specific tests for anamak FBT runs with special settings
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.
  
  methods(Test,TestTags={'Integration'})
    function test_nc_passing(testCase)
      L = fbt('ana',1,[],'nc',10);
      testCase.assertEqual(L.P.nc,10);
      testCase.assertSize(L.P.limc,[10,10]);
   
      %%
      testCase.assertError(@() fbt('ana',1,[],'nc',10,'limu',zeros(8,1)),'fbtpana:limuSize');
    end
  end
end
