classdef bffbt_tests < meq_test
  % Specific tests for BFFBT basis function set
  %
  % See also bf_tests bf_jacobian_test
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  methods (Test,TestTags={'Unit'})
    function test_Inf_NaN_jacobian(testCase)
      % Check that bffbt with bfp(3)<1 or bfp(6)<1 does not yield non-finite values

      % Get dummy flux map
      r0 = 1;
      z0=0;
      rBt = 1;
      FA = 0;
      FB = 1;
      L = liu('ana',1);
      [L,LY] = testCase.getCircularEquilibrium(L,r0,z0,FA,FB,rBt);

      % Get parameters
      bfp = [1.1 .25 1.75 2.2 .75 0.5].';

      % Check mode 1 outputs
      [Tyg,TpDg,ITpDg] = bffbt(1,bfp,LY.Fx,FA,FB,LY.Opy,L.ry,L.iry);

      % Check that outputs are all finite
      testCase.verifyTrue(all(isfinite(  Tyg(:))),'  Tyg contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite( TpDg(:))),' TpDg contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite(ITpDg(:))),'ITpDg contains Inf/NaN values');

      % Check mode 11 outputs
      [dTygdFy,dTygdF0,dTygdF1,dITygdF0,dITygdF1] = bffbt(11,bfp,LY.Fx,FA,FB,LY.Opy,L.ry,L.iry);

      % Check that outputs are all finite
      testCase.verifyTrue(all(isfinite( dTygdFy(:))),' dTygdFy contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite( dTygdF0(:))),' dTygdFy contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite( dTygdF1(:))),' dTygdFy contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite(dITygdF0(:))),'dITygdFy contains Inf/NaN values');
      testCase.verifyTrue(all(isfinite(dITygdF1(:))),'dITygdFy contains Inf/NaN values');
    end

    function test_negative_exponents(testCase)
      % Check that bfp(3)<0 or bfp(6)<0 is impossible with bffbt

      fun = @(ell1,emm1) fbt('ana',1,[],'bfct',@bffbt,'ell1',ell1,'emm1',emm1);

      % Check ell1<0 (bfp(3)<0) yields error
      testCase.verifyError(@() fun(-1,1),'MEQ:ParameterError','FBT setup with bffbt and bfp(3)<0 did not yield the correct error')

      % Check emm1<0 (bfp(6)<0) yields error
      testCase.verifyError(@() fun(1,-1),'MEQ:ParameterError','FBT setup with bffbt and bfp(6)<0 did not yield the correct error')
    end
  end
end
