classdef bf_multi_domain_jacobian_test < bf_jacobian_test
  % test the analytical jacobian of the multi domain basis function sets
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties(ClassSetupParameter)
    shot = struct(meq_jacobian_test.doublets_under_test{:});
  end
  
  properties (MethodSetupParameter)
    bfct = {'bfgenD','bfdoublet','bfdoublet'};
    bfp  = {
      bfpgenD(   {@bfabmex,[1,2],[1;0;0];@bfabmex,[1,2],[0;1;0];@bfabmex,[0,1],[1;1;1]},3),...
      bfpdoublet({@bfabmex,[1,2]        ;@bfabmex,[1,2]        ;@bfabmex,[0,2]}          ),...
      bfpdoublet(mixed_case_bfp()) % mixed types
      };
  end

end


function bfp = mixed_case_bfp()
% example bf3imex parameter generator
n=41; FN = linspace(0,1,n)';
oo = ones(n,1);
GN = [(1-FN),oo,oo];
IGN = bfprmex(GN);
FP = [0;0;0]; FT = [1;1;1];
bfp3i = struct('gNg',GN,'IgNg',IGN,'fPg',FP,'fTg',FT);

bfp = {...
  @bfabmex, [1,1]; ...
  @bfabmex, [1,1]; ...
  @bf3imex, bfp3i};

end
