classdef bf3p_tests < bf_comp_tests
  % Compare bf3pmex with bfabmex
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.

  properties
    bf1 = 'bf3pmex';
    bf2 = 'bfabmex';
  end

  properties (TestParameter)
    % Sequential combination 1st with 1st, 2nd with 2nd etc.
    bfp1 = {false} % true
    bfp2 = {[1,2]} % [0,1]
    % Comparison with circular mode is difficult since ng is still 3 for bf3pmex[circ=true] while ng=1 for bfabmex[nP=0,nT=1]
  end

  methods (Test, ParameterCombination='sequential', TestTags={'Unit','bf'})
    function test_mode4(testCase,bfp1,bfp2)
      testCase.assumeFail('Mode 4 (vertical chord integrals) not yet implemented in bf3pmex')
    end

    function test_mode7(testCase,bfp1,bfp2)
      testCase.assumeFail('Mode 7 (inequality constraints) not yet implemented in bf3pmex')
    end

    function test_mode17(testCase,bfp1,bfp2)
      testCase.assumeFail('Mode 17 (derivatives of inequality constraints) not yet implemented in bf3pmex')
    end
  end
end
