classdef (SharedTestFixtures={mexm_fixture}) bboxmex_test < meq_test
  % Tests for domain bounding box 
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.
  
  properties
    L
  end

  properties (TestParameter)
    method = {'bboxmex','bboxmexm'};
  end

  methods(TestClassSetup)    
    function setupLLY(testCase)
      testCase.L = fbt('ana',1,[],'pql',0.1);
    end
  end

  methods(Test,TestTags={'Unit'})
    % Test methods

    function test_bbox(testCase,method)
      % Verify that bbox gives the expected result

      L = testCase.L; %#ok<*PROPLC,*PROP> 
      
      %% Fake circular equilibrium
      r0 = 1.001; z0 = 0;
      FA = 1; FB = 0;
      rBt = 1;
      [L,LY] = testCase.getCircularEquilibrium(L,r0,z0,FA,FB,rBt);
      
      Opy = logical(LY.Iy);

      % Expected values
      rmin = L.ry(find(any(Opy,1),1,'first'));
      rmax = L.ry(find(any(Opy,1),1,'last'));
      zmin = L.zy(find(any(Opy,2),1,'first'));
      zmax = L.zy(find(any(Opy,2),1,'last'));
      B_ = [zmin,rmin,zmax,rmax];

      % test vs mex/mexm
      B = feval(method,Opy,L.zy,L.ry);

      testCase.verifyEqual(B,B_,sprintf('%s results do not match expected values',method));

    end
  end

end
