classdef anamak_multiD_tests < meq_test
  % Test for multidimensional anamak cases.
  %
  % [+MEQ MatlabEQuilibrium Toolbox+]

  %    Copyright 2022-2025 Swiss Plasma Center EPFL
  %
  %   Licensed under the Apache License, Version 2.0 (the "License");
  %   you may not use this file except in compliance with the License.
  %   You may obtain a copy of the License at
  %
  %       http://www.apache.org/licenses/LICENSE-2.0
  %
  %   Unless required by applicable law or agreed to in writing, software
  %   distributed under the License is distributed on an "AS IS" BASIS,
  %   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  %   See the License for the specific language governing permissions and
  %   limitations under the License.
  
  properties (TestParameter)
    shot   = struct('circular',1,'diverted',2,'droplet',81,...
      'doublet', 82,'diverted_droplet_PFR',   83,...
      'diverted_droplet',   84,...
      'two_diverted_droplets',85,...
      'doublet_with_mantle_current',88);
    sIp    = {-1,1};
  end
  
  properties
    verbosity = 0;
  end
  
  methods(Test,TestTags={'Integration'})
    function test_FR(testCase,sIp,shot)
      % Test of Normalized X-point/Boundary flux ratio value
      [L,LX] = fbt('ana',shot,0,'izgrid',testCase.verbosity>0);
      LX.Ip  = sIp*LX.Ip;
      if L.nD > 1
        LX.IpD = sIp*LX.IpD;
      end
      LX.qA  = sIp*LX.qA;
      LX = fbtx(L,LX); % Necessary after manual LX update
      LY=fbtt(L,LX);
      
      if testCase.verbosity>0
        clf; meqplotfancy(L,LY); drawnow;
      end
      
      switch shot
        case 1
          testCase.verifyEqual(LY.FR,inf,'FR must be inf for circular eq')
        case 2
          testCase.verifyEqual(LY.FR,1,'FR must be 1 for diverted eq');
        case 81
          testCase.verifyGreaterThan(LY.FR(1:2),[1;1],'FR must be > [1 1] for droplets');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        case {82,88}
          testCase.verifySize(LY.FR,[3 1],'FR must have size [3,1] for doublet');
          testCase.verifyEqual(LY.FR(1:2),[1;1],'First 2 elements of FR must be [1 1] for doublet');
          testCase.verifyLessThan(LY.FR(3),1,'FR(3) must be <1 for doublet')
        case {83,84}
          testCase.verifyTrue(sum(LY.FR==1)==1,'FR must contain one entry =1 for diverted droplet');
          testCase.verifyTrue(sum(LY.FR>1)==1,'FR must contain one entry >1 for diverted droplet');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        case 85
          testCase.verifyEqual(LY.FR(1:2),[1;1],'First 2 elements of FR must be [1 1] for two diverted droplets');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        otherwise
          error('unknown shot %d',shot);
      end
    end
  end
  
end
