function solverinfo=initsolverinfo(varargin)
% Initialize solverinfo
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% Parse inputs
for k = 1:2:length(varargin), solverinfo.(varargin{k}) = varargin{k+1}; end

%% defaults for solverinfo
D.isconverged = 0;
D.failed = 0;
D.niter = 0;
D.residual_max = inf;
D.res = inf;
D.residual_2norm = inf;
D.restarts = 0;
D.mkryl = 0;
D.nfeval = 0;
D.stopped_early = false;
D.prev_H = [];

for k = fieldnames(D)'
  if ~isfield(solverinfo,k{1}), solverinfo.(k{1}) = D.(k{1}); end
end

end
