% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

clearvars, close all

% % new case with separate geometry and data
% geoFile = '/home/admele/data/SegTestJan2020/geo/ITER_create_G.mat';
% segFile = '/home/admele/data/SegTestJan2020/in/5_Case001_bellshape_curdriv_t610d000_t615d637_clean_CNL4LIUQE_Ip_stim.mat';
% time = 610:1e-3:610.5;
%
% old case with geometry in the same file as data
segFile = '/home/admele/data/SegTestJan2020/in/3_Case001_bellshape_curdriv_t079d000_t086d000_clean_CNL4LIUQE_Ip_stim.mat';
geoFile = segFile;
time = 79:1e-3:79.05;



%% 

% for Fterr = [0.05 0.1 1]
Fterr = 0.05;
[L,LX] = liu('create',{geoFile, segFile},time, ...
                'itert',2,'nr',128,'debug',0,...
                'Iperr',1e4,'Iaerr',1e3,'Iuerr',1e3 ,... 
                'Ipmin',1.7e6, ...
                'iterh',10,'tolh',1e-2,...
                'iters',12,...
                'bfct',@bf3pmex,'bfp',[],...  % Simulink only has bf3p
                'idml',1,...
                'wreg',8e-6,...
                'Fterr',Fterr,'slx',1); 

[LY] = liut(L,LX);
              
plot(LX.t,LX.Ft,LY.t,LY.Ft)

%pause        
%end