% Simple script to test fgs with analytical jacobian
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

for method = {'sim','giv','aya'}
  
  [L,LX] = fgs('ana',2,0, ...
               'tol',1e-4, ...
               'tolF',1e-10, ...
               'gsxe',3, ...
               'agcon',{'Ip','bp','qA'}, ...
               'algoF','jfnk', ...
               'algoGMRES',method{1}, ...
               'anajac',true, ...
               'usepreconditioner', false, ...
               'mkryl',150);
  
  LY = fgst(L,LX,'debug',2);

end
