% Simple script to test fge with analytical jacobian
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% initialization
[L,LX0] = fge('ana',2,0:1e-3:2e-3, ...
              'tol',1e-6, ...
              'tolF',1e-10, ...
              'gsxe',3, ...
              'agcon',{'Ip','bp','qA'}, ...
              'algoF','jfnk', ...
              'algoGMRES','sim', ...
              'anajac',true, ...
              'usepreconditioner', false, ...
              'mkryl',150);
sys = fgess(L);

[V,D] = eig(sys.A);
[D,ii] = esort(diag(D));
v = V(:,ii(1));
d = D(1);

deltaZ0 = 0.05;
sysZ = sys(sys.OutputGroup.zIp,:);

% compute state perturbation for this deltaZ0
x0 = -LX0.Ip(1)*deltaZ0*v/(sysZ.C(1,:)*v);

% assign to initial currents
LX = LX0;
LX.Ia = LX.Ia+x0(1:L.G.na);
LX.Iu = LX.Iu+x0(L.G.na+(1:L.G.nu));

%% time evolution
LY = fget(L,LX,'debug',2);
