%% Script for exercising LIUQE FE fit
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

clear all;

shot = 55331; time = 0:1e-4:0.05;
shot = 66938; time = 0.38:1e-4:0.45;

% Standard FE fit
[L,LX] = liuqe(shot,time,'iterh',0);

% IPMH FE fit
[Lh] = liuqe(shot,[],'iterh',30,'tolh',1e-3,...
  'Ipmin',10e3,'idoublet',true,...
  'rip',NaN,'rop',NaN,'zup',NaN,'zlp',NaN,'nelem',12);

%%
LY  = liht(L ,LX); % standard observer
LYh = liht(Lh,LX); % ipmh observer

%%
clf;
meqplotD(L,LY,LYh);

%%

