% Compute database of equilibrium reconstruction for doublet shots and store L,LX,LY
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.
close all
clear all 
clc

storefolderpath = '';

assert(~isempty(storefolderpath), 'Need to add the storing path')

shotlist = {68466,68511,68518,68710,68590,68596,68710,68712,68714,68716,68898,68895,68892,...
 69052, 69053,69054,69056,68957,69059,68060,69061,69098, 69100, 69103, 69107};
tin = 0.405;
tend = 0.412;
dt = 1e-4;

%% Compute equilibrium reconstruction with multiple domain post-processing
% Max resolution of equilibrium reconstruction is dt = 1e-4

for jj = 1:numel(shotlist)
  for ii=1:3
    fpath = sprintf('%s/%d/eqrec', storefolderpath,  shotlist{jj});
    if ~exist(fpath,'dir')
      mkdir(fpath);
    end
    trec = (tin + ii-1):dt:(tend + ii-1);
    
    inPar = liup_doublet('algoNL', 'jfnk');
    [L,LX,LY] = liu('tcv', shotlist{jj},trec, inPar{:});
    if ~isempty(LY)
      fname = sprintf('%s/%d_break_%d.mat', fpath, shotlist{jj}, ii);
      save(fname, 'L', 'LX','LY')
    end
  end
end