%% TCV rampup plotting demonstration
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

shot = 65568;
[L,LX,LY] = liuqe(shot,[0:1e-3:0.2],'wreg',1e-6,'fancyplot',true,'itert',2);

L = meqgz(L);
%
%%
figure(1); clf; shg;
fname = sprintf('rampup_movie_TCV%d',shot);
meqmovie(fname,L,LY,1:1:100,'style','fancy','dosave',true);

%%
figure(2);

subplot(211)
plot(LY.t,sign(LY.Ip(end))*sum(LY.Is,1)/1e3,'b',LY.t,sign(LY.Ip(end))*LY.Ip/1e3,'r')
legend('Sum(I_{vessel})','I_p','location','best')
ylabel('kA')
xlabel('t');
title(sprintf('TCV %d',shot));
set(gcf,'paperpositionmode','auto');

subplot(212)
plot(LY.t,LY.Ia(18:19,:)/1e3);
ylabel('kA/turn')
xlabel('t');
legend('Transformer circuit current','location','best')

print('-depsc',[fname,'_currents.eps'])