%% Script to perform radial scan using FGS
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

clear;

% [L,LX0] = fgs('tcv',65668,0.3,'fancyplot',true,'insrc','liu','debug',1,'iterq',10);
[L,LX0] = fgs('tcv',65279,0.6,'fancyplot',true,'insrc','liu','debug',1,'iterq',10);

%%
factgrid = linspace(0.95,1.08,8);

nr=2; nc = ceil(numel(factgrid)/nr);
figure(1); clf;
LY = LX0;
for ii=1:numel(factgrid)
  LX = LY; % previous as init
  LX.Ip = factgrid(ii)*LX0.Ip; % scale Ip
  LX.qA = LX0.qA; LX.bp = LX0.bp;
  LY = fgst(L,LX);
  
  subplot(nr,nc,ii);
  meqplott(L,LY);
  drawnow;
  
  R = LY.rgeom(end); a = LY.aminor(end); %(R,a of LCFS)
  titstr = sprintf('bp=%2.2f\nli=%2.2f\nR/a=%2.2f',LY.bp,LY.li,R/a);
  
  title(titstr,'fontsize',8)
  bpgrid(ii) = LY.bp;
  ragrid(ii) = R/a;
  rgrid(ii) = R;
end

%%
figure(2)
subplot(211)
plot(rgrid,ragrid)
xlabel('R'),ylabel('R/a');
subplot(212)
plot(rgrid,log(ragrid))
xlabel('R'),ylabel('ln(R/a)');
