%% Comparison between RZIP and FGE growth rete
% Compute the growth rate for linearized FGE and RZIP for several shot of different nature
% Warning computing the linearization if pretty slow at the moment ( need to solve equivalent of FGS ~ 300 times)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

close all
clear all
clc

%% 
addpath(genpath('/home/carpanes/meq_GIT'))
addpath(genpath('/home/carpanes/rzip'))

%% Compare the eigenvalue between RZIP and the linearized version for sevaral shots 
list_shot = [65668,65299,63783,40000];
t = 0.3; % Select timeslice during flat-top phase

%% Compute RZIP growth rates
for ii = 1:numel(list_shot)
[LFGS,~,LYFGS] = fge('TCV',list_shot(ii), t, 'insrc', 'liu');
[MFGE(ii)] = fgelin(LFGS,LYFGS);
[sys,sysinfo] = make_rzip_model('v',256,'fgs',LFGS,LYFGS,'TCV',1:19,list_shot(ii),t);
growFGE(ii) = max(real(eig(MFGE(ii).A)));
growth_rate(ii) = max(real(eig(sys.A)));
end
  
%% Plot all the growth rates
figure
hold on 
plot(1:numel(list_shot), growth_rate, '*', 'DisplayName', 'RZIP')
plot(1:numel(list_shot), growFGE, 'o',  'DisplayName', 'FGE')
xticks([1:numel(list_shot)])
xticklabels(cellstr(num2str(list_shot')))
ylabel('Growth rate [Hz]')
xlabel('shot')
legend('show')
title('Comparison of growthrate')



