% Load RZP parameters, overloading FGEP.
% P = rzpp(P,...)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [P] = rzpp(P,varargin)

%% Default Parameters
D.algoNL = 'all-nl';
D.agcon = {'Ip','bp','li'};  % residual function(s) for basis function coeff constraints (see help meqagcon)
D.lin   = true; % run linearized version (the only one present)
D.anajac = true; % Use analytical jacobian
D.usepreconditioner = false; % Do not use preconditioner

%Fast calculation parameters
D.rzpfast   = false; %fast calculation flag
D.gritermax  = int32(100); %maximum number of iterations for the fast growth rate calculation
D.grtol      = 1.e-4; %tolerance for the fast growth rate calculation
D.eigitermax = int32(100); %maximum number of iterations for the fast eigenvector calculation
D.eigtol     = 1.e-4; %tolerance for the fast eigenvector calculation
D.eigvinit   = []; %eigenvector starting assumption for the fast eigenvector calculation

%% Overwrites parameters from input and set defaults
for k = 1:2:numel(varargin), P.(varargin{k}) = varargin{k+1}; end
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P = fgep(P);

assert(strcmpi(P.algoNL,'all-nl'),'rzp only supports algoNL=all-nl');

end