function [LX] = rzpinit(L,LX)
% function [LX] = rzpinit(L,LX)
% Compute statonary-state initial condition for RZP, and LX.Va 
% (possibly time-varying, when solving CDE) to sustain the initial 
% equilibrium.
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% Find Ia, Iv, Va consistent with initial equilibrium.
LX = meqinit(L,LX);

%% Compute RZP output to have a consistent starting equilibrium
% Call meqreprocess for computing post-processing quantities
% necessary for rzpl, but not present after meqinit.
LX = meqreprocess(L,LX);
end
