function rzpfastmexify(L,FPS,store_dir,out_dir)
%% rzpfastgrmexify(L,store_dir,out_dir)
% Mexify all rzpfast* files for current model settings
% run test function to initialize variables such as (for tcv):
%
% L = rzp('tcv',61400,0.5,'selu','e','nu',30,'gritermax',100,'grtol',1.e-4,'eigitermax',100,'eigtol',1.e-4,'eigvinit',[]);
%
% FPS.bea = [contains(L.G.dima,'G'); zeros(L.G.nu,1)];
% FPS.bea = L.Tee_fast'*FPS.bea;
% FPS.Tps = 1.e-4;  %[s]
% FPS.Vsat = 280;   %[V] 566 if in series, but 280 if in antiseriers
% FPS.Iamax = 1600; %[A] 2000 if in series, but 1600 if in antiseriers
% FPS.na_sel = find(contains(L.G.dima,'G'));
% FPS.La = L.Mee(FPS.na_sel,FPS.na_sel);
%
% function to mexify:
% [K,b,alpha,beta,c] = rzpfastbase(Ia,Iu,Iy,Ip,rIp,Opy,N,F,Trd,Tzd,Tfzd,Tfrd,Tbzd,Tbrd,ny,np,ne,RBrye,RBzye,RBrye_fast,RBzye_fast)
% [m] = rzpfastm(K,b,N)
% [A,Ainv] = rzpfastA(alpha,beta,DD,K,DDinv)
% [gamma,res,it] = rzpfastgr(alpha,c,dd,dmax,iter_max,tol)
% [v,w,res,it,gamma_right,gamma_left] = rzpfasteig(gamma,A,iter_max,tol,v_init)
% [dzmax] = rzpfastdzmax(K,b,alpha,beta,gamma,v,w,Ainv,Va,Ia,Le,ne,bea,Vsat,Iamax,Tps,na_sel)
%
% Input
%   L: example structure used to identify variables dimension
%   FPS: example structure containing the vertical instability coils 
%              parameters (for the rzpfastdzmax mexification)
%   store_dir: directory where to store .c, .h, .sh and other non useful
%              files. Usually a temp directory of the user
%   out_dir: output directory where to place the mex (mexified) file
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

if nargin < 3 
  out_dir = fileparts(mfilename('fullpath'));
  if nargin < 2
    store_dir = sprintf('/tmp/%s',getenv('USER'));
  end
end

%% define examples
%input from equilibrium
Ia         = coder.typeof(single(ones(L.G.na,1)));
Iu         = coder.typeof(single(ones(L.G.nu,1)));
Iy         = coder.typeof(single(ones(L.nzy,L.nry)));
Ip         = coder.typeof(single(ones(L.nD,1)));
rIp        = coder.typeof(single(ones(L.nD,1)));
Va         = coder.typeof(single(ones(L.G.na,1)));

%matrices from the base change used in the fast codes
N          = coder.typeof(single(L.N));
F          = coder.typeof(single(L.F));
dd         = coder.typeof(single(L.dd));
DD         = coder.typeof(single(L.DD));
DDinv      = coder.typeof(single(L.DDinv));
dmax       = coder.typeof(single(L.dmax));
Le         = coder.typeof(single(L.Le_fast));
Trd        = coder.typeof(single(L.Trd));
Tzd        = coder.typeof(single(L.Tzd));
RBrye      = coder.typeof(single(L.RBrye));
RBzye      = coder.typeof(single(L.RBzye));
RBrye_fast = coder.typeof(single(L.RBrye_fast));
RBzye_fast = coder.typeof(single(L.RBzye_fast));

%arrays containing the information on the coils used for the vertical control (for rzpfastdzmax)
bea        = coder.typeof(single(FPS.bea));
Vsat       = coder.typeof(single(FPS.Vsat));
Iamax      = coder.typeof(single(FPS.Iamax));
Tps        = coder.typeof(single(FPS.Tps));
na_sel     = coder.typeof(single(FPS.na_sel));

%dimensions
ny         = coder.typeof(int32(L.ny));
np         = coder.typeof(int32(L.np));
ne         = coder.typeof(int32(L.ne));

%results from rzpfastbase
K          = coder.typeof(single(ones(2,2)));
b          = coder.typeof(single(ones(L.G.nu+L.G.na,2)));
alpha      = coder.typeof(single(ones(2,2)));
beta       = coder.typeof(single(ones(L.G.na+L.G.nu,2)));
c          = coder.typeof(single(ones(L.G.na+L.G.nu,2)));

%results from other rzpfast* used in rzpfastdzmax and rzpfasteig
gamma      = coder.typeof(single(ones(1,1)));
v          = coder.typeof(single(ones(L.G.na+L.G.nu,1)));
w          = coder.typeof(single(ones(L.G.na+L.G.nu,1)));
A          = coder.typeof(single(ones(L.G.na+L.G.nu,L.G.na+L.G.nu)));
Ainv       = coder.typeof(single(ones(L.G.na+L.G.nu,L.G.na+L.G.nu)));

%tuning parameters for numerical application of the fast algorihtms (rzpfastgr and rzpfasteig)
gritermax  = coder.typeof(int32(L.P.gritermax)); 
grtol      = coder.typeof(single(L.P.grtol));
eigitermax = coder.typeof(int32(L.P.eigitermax)); 
eigtol     = coder.typeof(single(L.P.eigtol));
eigvinit   = coder.typeof(single(ones(L.G.na+L.G.nu,1)));

%% general settings
codercfg = coder.config('mex');
code_folder = store_dir;
if ~exist(code_folder,'dir')
  mkdir(code_folder);
end

%% fila names and inputs for mexification
file_name = {'rzpfastbase','rzpfastm','rzpfastA','rzpfastgr','rzpfasteig','rzpfastdzmax'};
example_inputs{1} = {Ia,Iu,Iy,Ip,rIp,N,F,Trd,Tzd,ny,np,ne,RBrye,RBzye,RBrye_fast,RBzye_fast};
example_inputs{2} = {K,b,N};
example_inputs{3} = {alpha,beta,DD,K,DDinv};
example_inputs{4} = {alpha,c,dd,dmax,gritermax,grtol};
example_inputs{5} = {gamma,A,eigitermax,eigtol,eigvinit};
example_inputs{6} = {K,b,alpha,beta,gamma,v,w,Ainv,Va,Ia,Le,ne,bea,Vsat,Iamax,Tps,na_sel};

for ii = 1:numel(file_name)
  out_file = fullfile(out_dir,[file_name{ii} '_mex']);
  entry_point_fct = which(file_name{ii});
  
  % check if correct mex already exists
  if exist(out_file,'file')
    disp([file_name{ii} '_mex already seems to exist for this model'])
    fprintf('Delete %s to force generation of new mex\n',which([file_name{ii} '_mex.mexa64']))
    return
  end
  
  % run codegen
  fprintf(['Generating mex for ' file_name{ii} ', please wait...'])
  codegen('-d',code_folder,'-o',out_file,'-config',codercfg,'-v',entry_point_fct,'-args',example_inputs{ii});
  fprintf('..done\n')
end

end