function [m] = rzpfastm(K,b,N)
%% [m] = rzpfastm(K,b,N)
% Function to be mexified. It comprises the calculation of the ideal
% instability margin (E.A. Lazarus et al 1990 Nucl. Fusion 30 111, 
% A. Portone 2005 Nucl. Fusion 45 926). If the ideal instability margin is
% lesss than zero, the plasma is either stable or ideally unstable.
%
% m: ideal instability margin
%
% An example of the use of the calculation of the growth rate with
% different methods:
%
% [L,LX] = rzp(tok,shot,t);
%
% %% Using rzpfastgm
% [m] = rzpfastm(LX.Ia,LX.Iu,LX.Iy,LX.Ip,LX.rIp,...
%        L.invMee,L.RBrye,L.RBzye,L.drx,L.dzx,L.ny,L.np,L.ne,L.icde);
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%#codegen  
beta_pre = N*b'*b*N;
det_K = K(1,1)*K(2,2)-K(1,2)*K(2,1);
K_pre = zeros(2,2);
K_pre(1,1) = K(2,2)/det_K;
K_pre(2,2) = K(1,1)/det_K;
K_pre(1,2) = -K(1,2)/det_K;
K_pre(2,1) = -K(2,1)/det_K;

a = beta_pre(2,1)*(K_pre(1,2)+K_pre(2,1))+beta_pre(2,2)*K_pre(2,2)+beta_pre(1,1)*K_pre(1,1);
c = (beta_pre(1,2)^2-beta_pre(1,1)*beta_pre(2,2))*(K_pre(1,2)*K_pre(2,1)-K_pre(1,1)*K_pre(2,2));

minus = (a-2-sqrt(a^2-4*c))/2;
mplus = (a-2+sqrt(a^2-4*c))/2;

m = max(mplus,minus);
end