function [L,TP] = rzpfastgrslx_init()
% RZPFASTGRSLX_INIT Initialise fixed and tunable parameter for simulink block of rzpfastgr
%  [FP,TP] = rzpfastgrslx_init()
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% fixed
fprintf('initializing rzp..')
Lrzp = rzp('tcv',61400,1,'selu','e','nu',30);
Lliu = liu('TCV',-1,[],...
           'psrc','RTLIUQE',... % Use parameters stored in \PCS::TOP.RTLIUQE_1.PARAMETERS
           'slx',1,...          % Enforce Simulink version
           'infct',@qintmex,...
           'rn',ones(25,1),...
           'zn',ones(25,1),...
           'bslvdprec',true...   
 );   % Use double precision for (Ie,ag) LSQ fit
fprintf('done\n')

L.G.na       = int32(Lrzp.G.na);
L.G.nu       = int32(Lrzp.G.nu);
L.nD         = int32(Lrzp.nD);
L.nry        = int32(Lrzp.nry);
L.nzy        = int32(Lrzp.nzy);
L.ny         = int32(Lrzp.ny);
L.np         = int32(Lrzp.np);
L.ne         = int32(Lrzp.ne);
L.N          = single(Lrzp.N);
L.F          = single(Lrzp.F);
L.Trd        = single(Lrzp.Trd);
L.Tzd        = single(Lrzp.Tzd);   
L.RBrye      = single(Lrzp.RBrye);
L.RBzye      = single(Lrzp.RBzye);
L.RBrye_fast = single(Lrzp.RBrye_fast);
L.RBzye_fast = single(Lrzp.RBzye_fast);
L.dd         = single(Lrzp.dd);
L.dmax       = single(Lrzp.dmax);

% matrix mapping Iv to Iu in RZP format
Tivu     = single(pinv(Lrzp.G.Tvu));
Tvuliu   = single(Lliu.G.Tvu);
L.G.Tuuliu   = Tivu*Tvuliu;
L.rry        = single(Lliu.rry);
L.G.nuliu    = int32(Lliu.G.nu);

% tunable
S.iter_max = int32(Lrzp.P.gritermax);
S.tol      = single(Lrzp.P.grtol);
TP = Simulink.Parameter(S);

end