function [A,Ainv] = rzpfastA(alpha,beta,DD,Kinv,DDinv)
%% [A,Ainv] = rzpfastA(alpha,beta,DD,K,DDinv)
% Function to be mexified. It comprises the fast version for the system
% matrix (A) calculation. The matrix A calculation is the equivalent to the
% one performed in fgess, however it only uses the necessary steps,
% speeding up the computation.
%
% An example of the use of the function and how to retrieve the matrix A
% from fgess follow:
%
% [L,LX] = rzp(tok,shot,t);
%
% %% Using rzpfastA
% A = rzpfastA(LX.Ia,LX.Iu,LX.Iy,LX.Ip,LX.rIp,LX.bp,...
%         L.Mey,L.Mee,L.Re,LX.Rp,L.RBrye,L.RBzye,L.drx,L.dzx,L.ny,L.np,L.ne,L.icde);
%
% %% Using fgess
% sys = fgess(L);
% A = sys.A;
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%#codegen  
%% Generate A matrix in continuous time representation
if nargin < 4
  Kinv = eye(2,2,'single');
  DDinv = eye(size(DD),'single');
end

A = -DD + (beta*alpha*beta')*DD;

if nargout > 1
  Ainv = -DDinv + DDinv*(beta*Kinv*beta');
end

end