function L = rzpc(P,G)
% RZPC Parameter consolidation for rzp
%  L = rzpc(P,G)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

%% Generic fgec ancilliary data (includes fgsc and meqc)
L = fgec(P,G);

%% Code specific functions
L.codeinit = @rzpinit; % Initialise the equilibrium based on rzpinit.m
L.codeFlin = @rzpFlin; % Call the linearisation for the rzp force balance
L.code = 'rzp';

%% State and residual scaling
L.xscal(L.ind.ixg) = [L.Ip0;1;1]; % [Ip,Rc,Zc]
if L.icde
  L.resscal(L.ind.irC) = 1 / (0.5*mu0*L.Ip0^2); % Fr, Fz
  L.resscal(L.ind.irp) = 1;
else
  L.resscal(L.ind.irC) = 1./[L.Ip0;0.5*mu0*L.Ip0^2*ones(2,1)]; % [Ip,Fr,Fz]
end
% State from L,LX
L.LX2x = @(LX) [LX.Iy(:);LX.ag;LX.Ia;LX.Iu]./L.xscal; % Required since L.xscal has been updated


%% Specific structures for the linearisation
L.drdrMye = [L.G.drdrMxa(L.lxy(:),:) L.G.drdrMxu(L.lxy(:),:)];
L.drdzMye = [L.G.drdzMxa(L.lxy(:),:) L.G.drdzMxu(L.lxy(:),:)];
L.dzdzMye = [L.G.dzdzMxa(L.lxy(:),:) L.G.dzdzMxu(L.lxy(:),:)];
L.Bzye    = [L.G.Bzxa(L.lxy(:),:)    L.G.Bzxu(L.lxy(:),:)   ];

%% Specific rzpFlinfast structures
L.RBrye = -[L.G.dzMxa(L.lxy(:),:) L.G.dzMxu(L.lxy(:),:)]./(2*pi);
L.RBzye =  [L.G.drMxa(L.lxy(:),:) L.G.drMxu(L.lxy(:),:)]./(2*pi);

%% Specific structures for fast implementation
[Tee_fast,Le_fast,Re_fast] = vveig(L.Mee,L.Re,'M');
L.Tee_fast = Tee_fast; 
L.RBrye_fast = L.RBrye*Tee_fast;
L.RBzye_fast = L.RBzye*Tee_fast;
L.N = 1/sqrt(Le_fast); 
L.F = sqrt(diag(Re_fast)/Le_fast)*L.N;
L.dd = real(Re_fast'/Le_fast);
L.DD = diag(L.dd);
L.DDinv = diag(1./L.dd);
L.dmax = max(abs(L.dd));
L.Le_fast = Le_fast;
L.Re_fast = Re_fast;
L.invMee = eye(L.ne)/Le_fast;
L.Trd = (diag(0*ones(1,L.nry)) + diag(-1*ones(1,L.nry-1),1) + diag(1*ones(1,L.nry-1),-1)) ./(2*L.drx);
L.Tzd = (diag(0*ones(1,L.nzy)) + diag(1*ones(1,L.nzy-1),1)  + diag(-1*ones(1,L.nzy-1),-1))./(2*L.dzx);

end