%RTCIMEX  Isoflux contouring
% [A,DAN,R,Z,IR] = RTCIMEX(A,ERO,EZO,F,FQ,CR,CZ,OPY,FO,OPO,DAP,RO,CRO,ZO,CZO)
% updates the previous guess for A(rh,th), the distance from the points
% (RO,ZO) to the flux surface with normalised coordinate rh~=0 at poloidal
% angle th. 
% R=RO+A*CRO, Z=RO+A*CZO, IR=1/R, 
% ERO=(RO-r(1))/dr, EZO=(ZO-z(1))/dz, with r(1),z(1) the smallest r,z grid points
% F(z,r) flux map, FQ(rh) the flux value for rh,
% CRO=-cos(th), CR=CRO/dr, CZO=sin(th), CZ=CZO/dz
% OPY is the mapping of the different plasma domains
% FO is the value of the flux at the origin of each segment
% OPO is the domain identifier at the origin of each segment
% DAP limits the update, DAN is the largest update.
%
% For details, see: [MEQ-redbook], Section "Wall Gaps" 
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function [varargout] = rtcimex(a,er0,ez0,Fx,F,c,s,Opy,Fo,Opo,dap,r,coq,z,soq)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = rtcimexm(a,er0,ez0,Fx,F,c,s,Opy,Fo,Opo,dap,r,coq,z,soq);
end
