function qpM = qintc(inp,dr,dz)
% Auxiliary function for qint.m
% Pre-computes matrix to get coefficients for quadratic interpolation on N
% points. See qintmex.m for details.
%
% INP: Structure of parameters containing:
%   n: Number of points for interpolation (minimum 6, maximum 9)
%      if INP is empty, uses N=9 (default);
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

% Returns ifp interpolation function parameter structure 
dr2=dr*dr; dz2=dz*dz; drdz=dr*dz;

if isempty(inp)
  n = 9;
else
  n = inp.n;
end

A = ...
 [1  0    0    0     0    0
  1  dr   0    0    dr2   0
  1 -dr   0    0    dr2   0
  1  0   dz    0     0   dz2
  1  0  -dz    0     0   dz2
  1  dr  dz  2*drdz dr2  dz2
  1 -dr -dz  2*drdz dr2  dz2
  1 -dr  dz -2*drdz dr2  dz2
  1  dr -dz -2*drdz dr2  dz2];
 
% Return pseudoinverse
qpM = pinv(A(1:n,:));
