function Ls = meqrmcde(L)
% substitute any 'CDE' entries with 'Ip' (FGS can not use CDE)
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

Ls=L;
icde = find(contains(lower(cellfun(@func2str,Ls.agconc(:,1),'UniformOutput',false)),'cde'));
for ii=1:numel(icde)
  ll = meqagconfun(); % catalog
  Ls.agconc{icde(ii),1} = ll{strcmp(cellfun(@func2str,ll,'UniformOutput',false),'Ip')};
  if ~L.P.idoublet, Ls.agconc{icde(ii),3} = 'Ip';
  else,             Ls.agconc{icde(ii),3} = 'IpD';
  end
end
end