%MEQPUT  MEQ anciliary function to put nodes in TCV trees
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function meqput(node,x,f,d,u,h,v,dep)
 if nargin < 7, v = -1; end
 if nargin < 8, dep = {}; end
 if strcmp(f,'t')
  % Text nodes (code)
  if numel(d) > 0 % String array
   expr = 'BUILD_PARAM(BUILD_SIGNAL($1,,$3),$2,)';
   put(node,expr,'x',mdscvt(x,f),h,d{1});
  else % String
   expr = 'BUILD_PARAM($1,$2,)';
   put(node,expr,'x',mdscvt(x,f),h);
  end
 else
  if     ischar(x)                    , expr = x; x = 0; f = 'd';
  elseif length(d) == 2 && isvector(x), expr = ['SET_RANGE(' sprintf('%d,',size(x)) '$1)'];
  else,                                 expr = '$1';
  end
  % mdsipmex does not support all Matlab data types, so convert in double
  expr = ['BUILD_PARAM(BUILD_SIGNAL(BUILD_WITH_UNITS(' expr ',$2),' sprintf(',%s',d{:}) '),$3,)'];
  if mdsdata('NODE_EXISTS($1)',[node ':FOO'])
   put([node ':FOO'        ],expr,'x',mdscvt(double(x),f),u,h)
   put([node ':COMMENT'    ],['HELP_OF(' node ':FOO)'],'x')
   put([node ':VERSION_NUM'],v)
   put([node ':NODES_USED' ],dep)
  else
   put(node,expr,'x',mdscvt(double(x),f),u,h)
   if mdsdata('NODE_EXISTS($1)',[node ':COMMENT']) % Only for R_RHO/Z_RHO in LIUQE trees at the moment
    put([node ':COMMENT'    ],['HELP_OF(' node ')'],'x')
   end
  end
 end
 
 function put(node,varargin)
  stat = mdsput(node,varargin{:});
  assert(isodd(stat),'Cannot put node %s (%s)',node,mdsdata('GETMSG($1)',stat))
 end

end
