% Printing progress bar to terminal
%
% [+MEQ MatlabEQuilibrium Toolbox+]

%    Copyright 2022-2025 Swiss Plasma Center EPFL
%
%   Licensed under the Apache License, Version 2.0 (the "License");
%   you may not use this file except in compliance with the License.
%   You may obtain a copy of the License at
%
%       http://www.apache.org/licenses/LICENSE-2.0
%
%   Unless required by applicable law or agreed to in writing, software
%   distributed under the License is distributed on an "AS IS" BASIS,
%   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%   See the License for the specific language governing permissions and
%   limitations under the License.

function meqprogress(it,nt,reset,displaynr)
% progress bar display
% it: iteration counter
% nt: total iterations
% reset: flag for resetting state
% displaynr: optional display of a string or scalar instead of a dot.
if nargin<3; reset=false; end
if nargin<4; dstr = '.';
else
  assert(numel(displaynr)==1,'can only display a scalar');
  if isnumeric(displaynr), dstr = sprintf('%d',displaynr);  % string to be displayed
  elseif ~ischar(displaynr), error('displaynr must be numeric or char')
  end
end

persistent clearBar currentLength
if isempty(clearBar) || reset
  clearBar = 0;
  currentLength = 0;
end

strDotsMaximum = 50;
nDots = min(floor(it/nt*strDotsMaximum),strDotsMaximum);
dotOut = sprintf('[%-*s] %d/%d',strDotsMaximum,repmat(dstr,1,nDots),it,nt);
if clearBar
  S = repmat('\b',1,currentLength);
  fprintf(S);
end
fprintf(dotOut);
clearBar = 1;
currentLength = numel(dotOut);
if it==nt
  fprintf('\n'); % end
end
end